package gov.va.vinci.dart.db.impl;

import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.db.DocumentTemplateDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

import java.util.List;

import javax.persistence.Query;

public class DocumentTemplateDAOImpl extends HibernateDAO implements DocumentTemplateDAO {

	@Override
	@SuppressWarnings("unchecked")
	public List<DocumentTemplate> listAll() {
		Query q = createQuery("from DocumentTemplate order by sortOrder");
		return (List<DocumentTemplate>) q.getResultList();
	}

	@Override
	public DocumentTemplate findById(final int documentTemplateId) {
		Query q = createQuery("from DocumentTemplate where id=:dtid");
		q.setParameter("dtid", documentTemplateId);
		return (DocumentTemplate) q.getSingleResult();
	}

}
